/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.item;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.TooltipBuilder;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;

public class SpaghettiItem
extends ModifiableItem {
    private static final Component SPAGHETTI = TConstruct.makeTranslation((String)"modifier", (String)"spaghetti");
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "spaghetti");

    public SpaghettiItem(Item.Properties properties, ToolDefinition toolDefinition) {
        super(properties, toolDefinition);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return ToolStack.from((ItemStack)stack).getPersistentData().getInt(this.KEY) < 100;
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        float f = Math.max(0.0f, (float)ToolStack.from((ItemStack)pStack).getPersistentData().getInt(this.KEY) / 100.0f);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int m_142158_(ItemStack pStack) {
        int uses = ToolStack.from((ItemStack)pStack).getPersistentData().getInt(this.KEY);
        return uses > 0 ? DurabilityDisplayModifierHook.getWidthFor((int)uses, (int)100) : 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        int level = tool.getModifierLevel(Utils.spaghetti.get());
        if (SafeClientAccess.getTooltipKey() == TooltipKey.SHIFT) {
            tooltip.add((Component)Component.m_237113_((String)"").m_7220_(SPAGHETTI).m_7220_(TooltipBuilder.formatPartialAmount((int)tool.getPersistentData().getInt(this.KEY), (int)100)));
            tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.food_level").m_7220_((Component)Component.m_237113_((String)Util.COMMA_FORMAT.format((long)level < 3L ? 3L : 5L)).m_130938_(style -> style.m_178520_(-2661276))));
            tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.saturation_level").m_7220_((Component)Component.m_237113_((String)Util.COMMA_FORMAT.format((long)level < 3L ? (double)((float)level * 1.2f + 1.2f) : 6.0)).m_130938_(style -> style.m_178520_(-8871731))));
            if (tool.getFreeSlots(SlotType.UPGRADE) > 0) {
                tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.upgrades").m_7220_((Component)Component.m_237113_((String)Util.COMMA_FORMAT.format(tool.getFreeSlots(SlotType.UPGRADE))).m_130938_(style -> style.m_178520_(-3360185))));
            }
            if (level > 1) {
                tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.sauce").m_130938_(style -> style.m_178520_(-8042548)));
                if (level > 2) {
                    tooltip.add((Component)Component.m_237115_((String)"modifier.tinkerscalibration.spaghetti.meat").m_130938_(style -> style.m_178520_(-8042548)));
                }
            }
        } else {
            TooltipUtil.addModifierNames((ItemStack)stack, (IToolStackView)tool, tooltip, (TooltipFlag)flag);
            tooltip.add(TooltipUtil.TOOLTIP_HOLD_SHIFT);
        }
    }
}

